/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.tiviacz.travelersbackpack.capability.CapabilityUtils;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class ClearBackpackCommand {
    public ClearBackpackCommand(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder tbCommand = (LiteralArgumentBuilder)Commands.m_82127_((String)"tb").requires(player -> player.m_6761_(2));
        tbCommand.then(((LiteralArgumentBuilder)Commands.m_82127_((String)"remove").executes(source -> ClearBackpackCommand.removeBackpack((CommandSourceStack)source.getSource(), ((CommandSourceStack)source.getSource()).m_81375_()))).then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(source -> ClearBackpackCommand.removeBackpack((CommandSourceStack)source.getSource(), EntityArgument.m_91474_((CommandContext)source, (String)"player")))));
        tbCommand.then(((LiteralArgumentBuilder)Commands.m_82127_((String)"clear").executes(source -> ClearBackpackCommand.clearBackpack((CommandSourceStack)source.getSource(), ((CommandSourceStack)source.getSource()).m_81375_()))).then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(source -> ClearBackpackCommand.clearBackpack((CommandSourceStack)source.getSource(), EntityArgument.m_91474_((CommandContext)source, (String)"player")))));
        dispatcher.register(tbCommand);
    }

    private static int removeBackpack(CommandSourceStack source, ServerPlayer player) throws CommandSyntaxException {
        if (CapabilityUtils.isWearingBackpack((Player)player)) {
            CapabilityUtils.getCapability((Player)player).ifPresent(cap -> {
                cap.setWearable(ItemStack.f_41583_);
                cap.setContents(ItemStack.f_41583_);
                cap.synchronise();
                cap.synchroniseToOthers((Player)player);
            });
            source.m_81354_((Component)Component.m_237113_((String)("Removed Traveler's Backpack from " + player.m_5446_().getString())), true);
            return 1;
        }
        source.m_81352_((Component)Component.m_237113_((String)("Player " + player.m_5446_().getString() + " is not wearing backpack")));
        return -1;
    }

    private static int clearBackpack(CommandSourceStack source, ServerPlayer player) throws CommandSyntaxException {
        if (CapabilityUtils.isWearingBackpack((Player)player)) {
            CapabilityUtils.getCapability((Player)player).ifPresent(cap -> {
                ItemStack stack = cap.getWearable();
                stack.m_41751_(new CompoundTag());
                cap.setWearable(stack);
                cap.setContents(stack);
                cap.synchronise();
                cap.synchroniseToOthers((Player)player);
            });
            source.m_81354_((Component)Component.m_237113_((String)("Cleared contents of Traveler's Backpack from " + player.m_5446_().getString())), true);
            return 1;
        }
        source.m_81352_((Component)Component.m_237113_((String)("Player " + player.m_5446_().getString() + " is not wearing backpack")));
        return -1;
    }
}

